IF OBJECT_ID('P_GERA_RC_DEB_CLI_PDV') IS NOT NULL
BEGIN
	DROP PROCEDURE P_GERA_RC_DEB_CLI_PDV
END

GO

CREATE PROCEDURE P_GERA_RC_DEB_CLI_PDV
AS
SET NOCOUNT ON

	BEGIN
					DECLARE @CD_CTR     BIGINT,
							@CD_EMP     INT,
							@CD_CLI     INT,
							@CD_CTR_XML BIGINT,
							@FAT_XML    XML;

			--INSERINDO REGISTROS DUPLICADOS PARA REPROCESSAMENTO
				INSERT INTO RC_DEB_CLI_PDV_PEND (cd_emp, cd_cli, dt_pend) 
				SELECT  1 AS CD_EMP, A.CD_CLI, GETDATE() FROM rc_deb_cli_pdv A WHERE NOT EXISTS (SELECT  1 FROM RC_DEB_CLI_PDV_PEND B WHERE A.CD_EMP = B.CD_EMP AND A.CD_CLI = B.CD_CLI) group by A.cd_cli having count (*) > 1 ;

			DECLARE PENDENTES CURSOR FAST_FORWARD FOR
				SELECT
					--top 1000
					P.CD_CTR
					,P.CD_EMP
					,P.CD_CLI
					,X.CD_CTR AS CD_CTR_XML
				FROM
					RC_DEB_CLI_PDV_PEND P
					LEFT JOIN RC_DEB_CLI_PDV X ON
						P.CD_EMP = X.CD_EMP AND
						P.CD_CLI = X.CD_CLI

			OPEN PENDENTES
			FETCH NEXT FROM PENDENTES INTO @CD_CTR, @CD_EMP, @CD_CLI, @CD_CTR_XML
			WHILE @@FETCH_STATUS = 0
				BEGIN
						DELETE FROM RC_DEB_CLI_PDV WHERE CD_CLI=@CD_CLI;

						EXECUTE P_GERA_RC_CREDIARIO_FECHA_CLIENTE @CD_CLI;
						SET @FAT_XML = ISNULL((SELECT * FROM dbo.UFD_RC_DEB_CLI_PDV(@CD_EMP, @CD_CLI, 0)
																	 FOR XML PATH('RC_DEB'), ROOT('FAT_XML')), '<FAT_XML><MSG>CLIENTE NAO POSSUI DEBITOS PENDENTES</MSG></FAT_XML>')

						INSERT INTO RC_DEB_CLI_PDV (CD_EMP,CD_CLI, FAT_XML)	VALUES (@CD_EMP, @CD_CLI, @FAT_XML);

						--REMOVE PENDENCIA
						DELETE FROM RC_DEB_CLI_PDV_PEND	WHERE  CD_CTR = @CD_CTR;

						FETCH NEXT FROM PENDENTES INTO @CD_CTR, @CD_EMP, @CD_CLI, @CD_CTR_XML
				END
			CLOSE PENDENTES
			DEALLOCATE PENDENTES
	END 


